clear all
set more off
set matsize 10500


program min_max
* input: a matrix
* scalar output: "min" for min value, "max" for max value

args x1 

local r=rowsof(`x1')
local c=colsof(`x1')

scalar min= 10000000
scalar max=-10000000

forvalue i=1(1)`r' {
	forvalue j=1(1)`c' {
		if `x1'[`i',`j']<min {
			scalar min=`x1'[`i',`j']
		}
		if `x1'[`i',`j']>max {
			scalar max=`x1'[`i',`j']
		}
	}
}

end


program gap1
* 1 variable tabulation
	scalar d=0

	forvalue i=1(1)5 {
		local x: word `i' of $rndX

		quietly: tab `x',matcell(kk)
		scalar S=r(N)

		min_max kk
		scalar d=d+(max-min)/S
	}
end



program gap2
* 2 variable tabulation
	scalar d=0

	forvalue i =1(1)4 {
		local x1: word `i' of $rndX
		local i1=`i'+1
		
		forvalue j=`i1'(1)5 {
			local x2: word `j' of $rndX
			
			quietly: tab `x1' `x2',matcell(kk)
			scalar S=r(N)
			
			min_max kk
			scalar d=d+(max-min)/S
		}
	}
end



program random1
	* Check randomness: 1 Var 
	scalar d=0
	scalar nsig=0
	
	forvalue i=1(1)5 {
		local x: word `i' of $rndX
		foreach z of varlist $demoVar {
			quietly: oneway `z' `x' //,tab 
	
			scalar d=d+r(F)
			
			scalar p_val= Ftail(r(df_m),r(df_r),r(F))
			if p_val<0.1 {
				scalar nsig=nsig+1
			}
		}
	}
end


program random2
* check randomess: 2 Var
	scalar d=0
	scalar nsig=0
	
	forvalue i =1(1)4 {
		local x1: word `i' of $rndX
		
		local i1=`i'+1
		
		forvalue j=`i1'(1)5 {
			local x2: word `j' of $rndX
			
			capture drop hh 
			egen hh=group(`x1' `x2')
			
			foreach z of varlist $demoVar {
				quietly: oneway `z' hh //,tab 
				
				scalar d=d+r(F)
			
				scalar p_val= Ftail(r(df_m),r(df_r),r(F))
				if p_val<0.1 {
					scalar nsig=nsig+1
				}

			}

		}
	}

end



* analysis
cd "D:\Studies\Halton sequence\Data"

use Halton1,clear

global demoVar gender young highedu marital 


//capture log close
//log using result.txt, text replace
//log off


*-------------- Actual results----------------
* halton sequence
global rndX candgender_rnd candname1 canedu_rnd canexp_rnd canrel_rnd

gap1 
disp "gap1: " d
gap2
disp "gap2: " d

random1
disp "Fstat1: " d "          N significant items: " nsig
random2
disp "Fstat2: " d "          N significant items: " nsig


* Blaise
global rndX candgender_blaise candname_blaise canedu_blaise canexp_blaise canrel_blaise

gap1 
disp "gap1: " d
gap2
disp "gap2: " d

random1
disp "Fstat1: " d "          N significant items: " nsig
random2
disp "Fstat2: " d "          N significant items: " nsig




*-------------- simulation -------------------
* randomizing the 5 random numbers for the 5 candiate characteristics

global rndX _gender _name _edu _exp _rel 

set seed 555

local N=10000

matrix G1=J(`N',1,0)
matrix G2=J(`N',1,0)

matrix R1=J(`N',2,0)
matrix R2=J(`N',2,0)


forvalue k=1(1)`N' {

	* generate random process
	forvalue i=1(1)5 {
		replace rnd`i'=runiform()
	}

	capture drop $rndX

	egen _gender=cut(rnd1),at(0(0.5)1)

	local step=1/6
	egen _name=cut(rnd2),at(0(`step')1)

	local step=1/3
	egen _edu=cut(rnd3),at(0(`step')1)

	egen _exp=cut(rnd4),at(0(0.5)1)
	egen _rel=cut(rnd5),at(0(0.5)1)

	
	* 1 variable tabulation
	gap1
	matrix G1[`k',1]=d/5

	* 2 variable tabulation
	gap2
	matrix G2[`k',1]=d/10
	
	
	* Check randomness: 1 Var 
	random1
	matrix R1[`k',1]=d
	matrix R1[`k',2]=nsig
	
	* Check randomness: 2 Var 
	random2
	matrix R2[`k',1]=d
	matrix R2[`k',2]=nsig
}


*---------- Results--------------------
matrix output=G1,G2,R1,R2
svmat output

keep output?
save random_output,replace

log on

sum output1 - output2

sum output3
tab output4		// compared to 0 in Halton

sum output5
tab output6		// compared to 2 in Halton

log off




dddddd

*-------------- simulation -------------------
* randomizing the sampled phone number order

set matsize 10500
set more off

cd "D:\Studies\Halton sequence\Data"
use Halton1,clear

global demoVar gender young highedu marital 
global rndX candgender_rnd candname1 canedu_rnd canexp_rnd canrel_rnd


keep $rndX
save tem,replace

use Halton1,clear
keep $demoVar


set seed 111
local N=10000

matrix G1=J(`N',1,0)
matrix G2=J(`N',1,0)

matrix R1=J(`N',2,0)
matrix R2=J(`N',2,0)

gen rnd0=.

forvalue k=1(1)`N' {

	* generate random process
	replace rnd0=runiform()
	sort rnd0
	
	quietly: merge 1:1 _n using tem
	drop _merge
	
	* 1 variable tabulation
	gap1
	matrix G1[`k',1]=d/5
	
	* 2 variable tabulation
	gap2
	matrix G2[`k',1]=d/10

	
	* Check randomness: 1 Var 
	random1
	matrix R1[`k',1]=d
	matrix R1[`k',2]=nsig
	
	* Check randomness: 2 Var 
	random2
	matrix R2[`k',1]=d
	matrix R2[`k',2]=nsig

	drop $rndX

}



*---------- Results--------------------
matrix output=G1,G2,R1,R2
svmat output

keep output?
save halton_output,replace


sum output1 - output2

sum output3
tab output4		// compared to 0 in Halton

sum output5
tab output6		// compared to 2 in Halton

